<?php
    //header("Content-Type:application/json");
    include("../connection.php");
     
    $errMsg = "";
    if (!isset($_REQUEST["codigo"])   || empty($_REQUEST["codigo"]) )   { $errMsg .= "No se recibio el Parametro codigo. "; } 
    if (!isset($_REQUEST["validata"]) || empty($_REQUEST["validata"]) ) { $errMsg .= "No se recibio el Parametro validata. "; } 
    
    $salida = new stdClass();

    if (!empty($errMsg) ){
        http_response_code(400);
        $salida->rsp = false;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }

    $codigo     = strtoupper(preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["codigo"])));
    $validata   = strtoupper(preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["validata"])));


    mysqli_query($db, "SET lc_time_names = 'es_ES'");
 
    $sql =  "SELECT id as userid, rif  " .
            "FROM   customers " .
            "WHERE  UPPER(pin) = ? ".
            "  AND  sessionid  = ? ".
            "  AND  IF(CURDATE()<sessionvalidthru, 1, 0) ";

    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("ss", $codigo, $validata);
            
    //Validamos la ejecuci贸n
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    $rs = mysqli_fetch_array($result);
    if (empty($rs)){
        http_response_code(401);
        //$salida->sql = $sql;
        $salida->rsp = true;
        $salida->msg = "Codigo incorrecto o caduco";
        echo (json_encode($salida));
        return;
    }
     
    $userid = $rs["userid"];

    http_response_code(200);
    $salida->rsp    = true;
    $salida->userid = $userid;
    echo (json_encode($salida));
 ?>
 