<?php
    header("Content-Type:application/json");
    include("../connection.php");
    
    $msgErr = "";
    if (!isset($_REQUEST["sessi"]) || empty($_REQUEST["sessid"]) ){ header("HTTP/1.1 400"); $msgErr .= "(falta sessionid)";}
    if (!isset($_REQUEST["id"])    || empty($_REQUEST["id"]))     { header("HTTP/1.1 400"); $msgErr .= "(falta id)";}
    
    $salida = new stdClass();
    
    if (empty($msgErr)){
        http_response_code(400);
        $salida->rsp = false;
        $salida->msg = "No se recibio el parámetro". $msgErr;
        echo (json_encode($salida));
        return;
    }

    $sessid     = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    $documentid = intval($db->real_escape_string($_REQUEST["id"]));
    
    $sql =  "SELECT sessionvalidthru, DATEDIFF(IFNULL(sessionvalidthru,NOW()), NOW()) active " .
            "FROM   customers " .
            "WHERE  sessionid = ? ";
            
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $sessid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
    	switch (mysqli_errno($db)){
    	    case 0:
    	    http_response_code(401);
            $salida->rsp = false;
            $salida->msg = "Sesion Inválida";
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
	        $salida->rsp = false;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }
    if ($rs["active"] < 0){
        http_response_code(401);
        $salida->rsp = false;
        $salida->msg = "Sesion Inválida";
        echo (json_encode($salida));
        return;        
    }

/*
    // Se borra el archivo (retencion) de ISLR 
    $fislr = $documentid."_islr.pdf";
    if( is_readable($fislr) ){ unlink($fislr); }
    // Se borra el registro de ISLR 
    $sql =  "DELETE FROM retislr WHERE documentid = " . $documentid  ;
    if (($qry = mysql_query($sql))){
        header("HTTP/1.1 500");
        $salida->rsp = false;
        $salida->msg = mysql_error();
        //$salida->sql = $sql;
        echo (json_encode($salida));
        return;        
    }
    
    // Se borra el archivo (retencion) de IVA
    $fislr = $documentid."_iva.pdf";
    if( is_readable($fislr) ){ unlink($fislr); }
    // Se borra el registro de IVA
    $sql =  "DELETE FROM retiva WHERE documentid = " . $documentid  ;
    if (!($qry = mysql_query($sql))){
        header("HTTP/1.1 500");
        $salida->rsp = false;
        $salida->msg = mysql_error();
        //$salida->sql = $sql;        
        echo (json_encode($salida));
        return;        
    }
*/    
    // Se borra el registro de Documents
    $sql =  "   DELETE      d ".
            "   FROM        documents d ".
            "   INNER JOIN  customers c ".
            "   ON          c.id = d.customerid ".
            "   WHERE       d.id = ? " .
            "   AND         c.sessionid = ? ";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("ss", $documentid, $sessid);
    
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false;
        $salida->msg = mysqli_error($db);
        //$salida->sql = $sql;
        echo (json_encode($salida));
        return;        
    }

    http_response_code(200);
    $salida->rsp = true;
    $salida->id = $documentid;
    echo (json_encode($salida));
    return; 
    

    
?>