<?php
    header("Content-Type:application/json");
    include("../connection.php");
    
    $errMsg = "";
    if (!isset($_REQUEST["sessid"]) || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid. "; } 
    if (!isset($_REQUEST["userid"])  || $_REQUEST["userid"] == '')    { $errMsg .= "No se recibio el Parametro userid. "; } 
    
    $salida = new stdClass();

    if (!empty($errMsg) ){
        http_response_code(400);
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }

    $custid = intval($db->real_escape_string($_REQUEST["userid"]));
    $sessid = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));

    mysqli_query($db, "SET lc_time_names = 'es_ES'");

    $sql =  "SELECT id, name as custname, custid, email as custmail " .
            "FROM   customers " .
            "WHERE  id = ? " .
            "AND    sessionid = ? " ;

    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("ss", $custid, $sessid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }

    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
    	switch (mysqli_errno($db)){
    	case 0:
    	    http_response_code(401);
            $salida->rsp = true ;
            $salida->msg = "falla en la sesión";
            $salida->errno = 0;
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
    	    $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
    	}
    }
    
    if ($rs["id"]<1){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = "NO SE QUE PASO";
        echo (json_encode($salida));
        return;
    }
            
    $custname  = $rs["custname"];
    $custid    = $rs["custid"];
    $custmail  = $rs["custmail"];

    http_response_code(200);
        $salida->rsp = true;
        $salida->custname   = $custname;
        $salida->custid     = $custid;
        $salida->custmail   = $custmail;
    echo (json_encode($salida));


?>

