<?php
    include("../connection.php");
    
    $errMsg = "";
    if (!isset($_REQUEST["sessid"]) || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid."; } 
    
    $salida = new stdClass();
    
    if (!empty($errMsg) ){
        http_response_code(400);
        $salida->rsp = false;
        $salida->errno = 1;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }

    $sessid = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));

    mysqli_query($db, "SET lc_time_names = 'es_ES'");

    $sql =  "SELECT id FROM customers WHERE sessionid = ? " ;

    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s",  $sessid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false;
        $salida->errno = 2;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }

    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
    	switch (mysqli_errno($db)){
    	case 0:
    	    http_response_code(401);
            $salida->rsp = true;
            $salida->msg = "Sesión no valida";
            $salida->errno = 3;
            echo (json_encode($salida));
            return;
            break;

        default:
            http_response_code(500);
            $salida->rsp = false;
            $salida->errno = 4;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
    	}
    }

    /* Se blanque cualquier otra session con el mismo numero */
    $sql =  "UPDATE customers SET sessionid = '' WHERE sessionid = ? ";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s",  $sessid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = true;
        $salida->errno = 5;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }  
    
    header("Content-Type:application/json");
    http_response_code(200);
    $salida->rsp = true;
    $salida->errno = 0;
    //$salida->sql = $sql;
    echo (json_encode($salida));
?>



