<?php
//    header("Content-Type:application/json");
    include("../connection.php");
    $errMsg = "";
    if ($_SERVER['REQUEST_METHOD']!= "POST") { $errMsg .= "Debe llamarse al servicio usando un POST"; } 
    if (!isset($_REQUEST["sessid"]) || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid. "; }
    
    $salida = new stdClass();
    
    $sessid     = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    if (!isset($_REQUEST["id"])){ 
        $documentid = 0;
    }else{
        $documentid = intval($db->real_escape_string($_REQUEST["id"]));        
    }

    if (isset($_REQUEST["customerid"]) )    { $customerid   = $db->real_escape_string($_REQUEST["customerid"])*1;}
    if (isset($_REQUEST["docdate"]) )       { $docdate      = preg_replace("/[^0-9\/\-]/", "",$db->real_escape_string($_REQUEST["docdate"]));}
    if (empty($docdate)) { $docdate = "  /  /    "; }
    if (isset($_REQUEST["doctype"]) )       { $doctype      = $db->real_escape_string($_REQUEST["doctype"])*1;}
    if (isset($_REQUEST["docnumber"]) )     { $docnumber    = preg_replace("/[^a-zA-Z0-9\/\-]/", "", $db->real_escape_string($_REQUEST["docnumber"]));}
    if (isset($_REQUEST["doccontrol"]) )    { $doccontrol   = preg_replace("/[^a-zA-Z0-9\/\-]/", "", $db->real_escape_string($_REQUEST["doccontrol"]));}
    if (isset($_REQUEST["base"]) )          { $base         = $db->real_escape_string($_REQUEST["base"])*1;}
    if (isset($_REQUEST["total"]) )         { $total        = $db->real_escape_string($_REQUEST["total"])*1;}
    if (isset($_REQUEST["pagado"]) )        { $pagado       = $db->real_escape_string($_REQUEST["pagado"])*1;}
    
    $islrswitch=isset($_REQUEST["islrswitch"]);
    if (isset($_REQUEST["islrdate"]) )      { $islrdate     = preg_replace("/[^0-9\/\-]/", "", $db->real_escape_string($_REQUEST["islrdate"]));}
    if (empty($islrdate)) { $islrdate = "  /  /    "; }
    if (isset($_REQUEST["islrnumber"]) )    { $islrnumber   = preg_replace("/[^a-zA-Z0-9\/\-]/", "", $db->real_escape_string($_REQUEST["islrnumber"]));}
    if (isset($_REQUEST["islramount"]) )    { $islramount   = $db->real_escape_string($_REQUEST["islramount"])*1;}
    if (isset($_REQUEST["islrstatus"]) )    { $islrstatus   = $db->real_escape_string($_REQUEST["islrstatus"])*1;}
    if (isset($_REQUEST["islrrepdate"]) )   { $islrrepdate  = preg_replace("/[^0-9\/\-]/", "", $db->real_escape_string($_REQUEST["islrrepdate"]));}
    if (empty($islrrepdate)) { $islrrepdate = "NULL"; }
    if (isset($_REQUEST["fileislr"]) )      { $fileislr     = $db->real_escape_string($_REQUEST["fileislr"]);}
    
    $ivaswitch=isset($_REQUEST["ivaswitch"]);
    if (isset($_REQUEST["ivadate"]) )       { $ivadate      = preg_replace("/[^0-9\/\-]/", "", $db->real_escape_string($_REQUEST["ivadate"]));}
    if (empty($ivadate)) { $ivadate = "  /  /    "; }
    if (isset($_REQUEST["ivanumber"]) )     { $ivanumber    = preg_replace("/[^a-zA-Z0-9\/\-]/", "", $db->real_escape_string($_REQUEST["ivanumber"]));}
    if (isset($_REQUEST["ivaamount"]) )     { $ivaamount    = $db->real_escape_string($_REQUEST["ivaamount"])*1;}
    if (isset($_REQUEST["ivastatus"]) )     { $ivastatus    = $db->real_escape_string($_REQUEST["ivastatus"])*1;}
    if (isset($_REQUEST["ivarepdate"]) )    { $ivarepdate   = preg_replace("/[^0-9\/\-]/", "", $db->real_escape_string($_REQUEST["ivarepdate"]));}
    if (empty($ivarepdate)) { $ivarepdate = "NULL"; }
    if (isset($_REQUEST["fileiva"]) )       { $fileiva      = $db->real_escape_string($_REQUEST["fileiva"]);}

    mysqli_query($db, "SET lc_time_names = 'es_ES'");
    
    /* Se valida el usuario y la session */
    $sql =  "SELECT id FROM customers ".
            "WHERE  id = ? AND ".
            "sessionid = ? AND IF(CURDATE()<sessionvalidthru, 1, 0)" ;
    
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("ss", $customerid, $sessid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            http_response_code(401);
            $salida->rsp = false ;
            $salida->msg = "Sesión inválida o caduca";
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
            $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }


    /************** Validaciones **********************/    
    $errlvl  = 0;
    $errMsg  = "";
    $salir = false;
    if( empty($errMsg) && (empty($customerid) || empty($docdate) || empty($docnumber) || empty($doccontrol)) ){
        $errMsg  = valerr(1);
        $salir   = true;
    }
    
    if($salir){
       if (!empty($errMsg) ){
           http_response_code(400);
           $salida->rsp = false;
           $salida->msg = $errMsg;
           echo (json_encode($salida));
           return;
       } 
    }

    $errMsg .=  doc_val();      // Validacion Documento
    if( isset($_REQUEST["islrswitch"]) ){
        $errMsg .=  islr_val();     // Validacion ISLR
    }
    if( isset($_REQUEST["ivaswitch"]) ){
        $errMsg .=  iva_val();  // Validacion de IVA
    }

    // Se verifica el nivel de error segun la descripción en 0 sin error, 1 Warning, 2 Critical    
    if(empty($errMsg)){
        $errlvl = 0;
    }else{
        $pos = strpos($errMsg, ")");
        if( !$pos || empty($pos) ){ $errlvl = 1; }else{ $errlvl = 2; }

        // Parse de los mensajes de error para eliminar el numero de error al jSon
        $newErrMsg = "";
        $errArray = explode("|",$errMsg);
        sort($errArray);
        foreach ($errArray as $value) {
            // Se consigue la posicion de ] ó ) en el string para eliminar el numero
            $pos = strpos($value, ")");
            if( !$pos || empty($pos) ){ 
                $pos = strpos($value, "]"); 
            }
            if($pos > 0 && !empty($value)){
                $value = substr( $value, $pos+1);
                $newErrMsg .= $value . "|";
            }
        }
        $errMsg = $newErrMsg;
    }

    /* Se valida si el registro es nuevo o no para hacer insert o update */
    $sql =  "SELECT id FROM documents WHERE customerid = ? AND id = ?";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("ss", $customerid, $documentid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    $rs = mysqli_fetch_array($result);
    $numofrecords = mysqli_num_rows($result) ;  

    if ($numofrecords > 0){ $newrecord = false; }else{ $newrecord = true; }

    // Datos de Factura ====================================================
    $doctype = 1;
    if($newrecord){
         $sql =  "INSERT INTO documents (" .
                    "customerid, ".
                    "docdate, ".
                    "doctype, ".
                    "docnumber, ".
                    "doccontrol, ".
                    "base, ".
                    "total, ".
                    "pagado, ".
                    "errlvl, ".
                    "errdsc".
                ") VALUES (".
                    " ?, ".
                    " ?, ".
                    " ?, ".
                    " ?, ".
                    " ?, ".
                    " ?, ".
                    " ?, ".
                    " ?, ".
                    " ?, ".
                    " ? ". 
                ")";
            
        $fmtdate = DateTime::createFromFormat('d/m/Y', $docdate)->format('Y-m-d');
        //Preparamos el statement
        $stmt =  $db->prepare($sql);
        //Remplazamos los parametros en la consulta almacenada
        $stmt->bind_param("ssssssssss", $customerid, $fmtdate, $doctype, $docnumber, $doccontrol, $base, $total, $pagado, $errlvl, $errMsg);
    }else{
        $sql =  "UPDATE documents SET " .
                "       customerid  =   ?, ".
                "       docdate     =   ?, ".
                "       doctype     =   ?, ".
                "       docnumber   =   ?, ".
                "       doccontrol  =   ?, ".
                "       base        =   ?, ".
                "       total       =   ?, ".
                "       pagado      =   ?, ".
                "       errlvl      =   ?, ".
                "       errdsc      =   ? ".
                "WHERE id = ? ";
                
        $fmtdate = DateTime::createFromFormat('d/m/Y', $docdate)->format('Y-m-d');
        //Preparamos el statement
        $stmt =  $db->prepare($sql);
        //Remplazamos los parametros en la consulta almacenada
        $stmt->bind_param("sssssssssss", $customerid, $fmtdate, $doctype, $docnumber, $doccontrol, $base, $total, $pagado, $errlvl, $errMsg, $documentid);

    }
    
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    if($newrecord){ $documentid = mysqli_insert_id($db); } // Se recupera el ultimo ID de la mas reciente ejecución de comando SQL    

    // Datos de Retencion ISLR ====================================================================   
    $sql = "DELETE FROM retislr WHERE documentid = ? ";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $documentid);
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }

    if($islrswitch){
        $dirorig = getcwd();
        // moverse al directorio de datos
        chdir("..");
        chdir("..");
        chdir("..");
        chdir("data/customer/islr");
        $datadir = getcwd();
        // volver a directorio inicial
        chdir($dirorig);

        if (isset($_FILES['fileislr']))
            move_uploaded_file($_FILES['fileislr']['tmp_name'], $datadir . "/" . $documentid . ".pdf");        
        
        $pdf = "";
        if (file_exists($datadir . "/" . $documentid . ".pdf"))
            $pdf = "/data/customer/islr/" . $documentid . ".pdf";
        
        if($islrrepdate !== 'NULL')
            $islrrepSQL = $islrrepdate;
        else
            $islrrepSQL = null;
        $sql =  "INSERT INTO retislr (" .
                    "documentid, ".
                    "islrnumber, ".
                    "islrdate, ".
                    "amount, ".
                    "repdate, ".
                    "pdf ".
                ") VALUES (" .
                        "?, ".
                        "?, ".
                        "?, ".
                        "?, ".
                        "?, ".
                        "? ".
                ")";

        $islrfmtdate = DateTime::createFromFormat('d/m/Y', $islrdate)->format('Y-m-d');
        //Preparamos el statement
        $stmt =  $db->prepare($sql);
        //Remplazamos los parametros en la consulta almacenada
        $stmt->bind_param("ssssss", $documentid,$islrnumber,$islrfmtdate,$islramount,$islrrepSQL,$pdf);
        //Validamos la ejecución
        if (!($stmt->execute())){
            http_response_code(500);
            $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
        }

    }
    

    // Datos de Retencion IVA ==================================================
    $sql = "DELETE FROM retiva WHERE documentid = ? ";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $documentid);
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }

    if($ivaswitch){
        $dirorig = getcwd();
        // moverse al directorio de datos
        chdir("..");
        chdir("..");
        chdir("..");
        chdir("data/customer/iva");
        $datadir = getcwd();
        // volver a directorio inicial
        chdir($dirorig);
        
        if (isset($_FILES['fileiva']))
            move_uploaded_file($_FILES['fileiva']['tmp_name'], $datadir . "/" . $documentid . ".pdf");

        $pdf = "";
        if (file_exists($datadir . "/" . $documentid . ".pdf"))
            $pdf = "/data/customer/iva/" . $documentid . ".pdf";
        if($ivarepdate !== 'NULL')
            $ivarepSQL = $ivarepdate;
        else
            $ivarepSQL = null;
        $sql =  "INSERT INTO retiva (" .
                    "documentid, ".
                    "ivanumber, ".
                    "ivadate, ".
                    "amount, ".
                    "repdate, ".
                    "pdf ".
                ") VALUES (" .
                        "?, ".
                        "?, ".
                        "?, ".
                        "?, ".
                        "?, ".
                        "? ".
                ")";
        $ivafmtdate = DateTime::createFromFormat('d/m/Y', $ivadate)->format('Y-m-d');
        //Preparamos el statement
        $stmt =  $db->prepare($sql);
        //Remplazamos los parametros en la consulta almacenada
        $stmt->bind_param("ssssss", $documentid,$ivanumber, $ivafmtdate,$ivaamount,$ivarepSQL,$pdf);
        //Validamos la ejecución
        if (!($stmt->execute())){
            http_response_code(500);
            $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
        }
    }

    if(empty($errMsg)){
        http_response_code(200);
        $salida->rsp        = true;
        $salida->errlvl     = 0;
        $salida->errdsc     = "";
        echo (json_encode($salida));
        return;
    }else{
        http_response_code(200);
        $salida->rsp        = true;
        $salida->errlvl     = $errlvl;
        $salida->errdsc     = $errMsg;
        echo (json_encode($salida));
        return;
    }

function valerr($errno){
    $errType = 1;
    
    switch ($errno) {
        case 1:
            $errdsc = "No se recibieron los datos mínimos para registrar la factura.";
            $errType = 2;
            break;
        case 2:
            $errdsc = "No se recibieron los valores de montos de la factura.";
            $errType = 2;
            break;
        case 3:
            $errdsc = "Número de factura excede de la longitud máxima.";
            break;            
        case 4:
            $errdsc = "Número de control es inválido.";
            break;            
        case 5:
            $errdsc = "Falta al menos uno de los impuestos.";
            $errType = 2;
            break;            
        case 8:
            $errdsc = "La factura ya fue registrada previamente.";
            $errType = 2;
            break;    
        case 9:
            $errdsc = "Monto pagado menos lo retenido, no concuerda con el total de la factura.";
            break;            
        case 10:
            $errdsc = "No se especificó la fecha de la retención del ISLR.";
            $errType = 2;
            break;
        case 11:
            $errdsc = "La fecha de la retención del ISLR es inferior a la fecha de la factura.";
            $errType = 2;
            break;
        case 12:
            $errdsc = "No se especificó el número del comprobante de la retención del ISLR.";
            break;            
        case 13:
            $errdsc = "Ya existe una retención del ISLR registrada con ese número que corresponde a otra factura.";
            $errType = 2;
            break;
        case 14:
            $errdsc = "No se especificó el monto de la retención del ISLR.";
            $errType = 2;
            break;
        case 15:            
            $errdsc = "No se especificó una tasa o porcentaje válido para la retención del ISLR. ";
            break;
        case 16:
            $errdsc = "No se seleccionó ningún archivo como comprobante de retención del ISLR.";
            $errType = 2;
            break;
        case 17:            
            $errdsc = "El archivo de la retención del ISLR debe ser formato PDF.";
            $errType = 2;
            break;
        
        case 20:
            $errdsc = "No se especificó la fecha de la retención del IVA.";
            $errType = 2;
            break;
        case 21:
            $errdsc = "La fecha de la retención del IVA es inferior a la fecha de la factura.";
            $errType = 2;
            break;
        case 22:
            $errdsc = "Ya existe una retención del IVA registrada con ese número que corresponde a otra factura.";
            $errType = 2;
            break;            
        case 23:
            $errdsc = "No se especificó el monto de la retención del IVA.";
            $errType = 2;
            break;
        case 24:
            $errdsc = "No se especificó una tasa o porcentaje válido para la retención del IVA.";
            break;
        case 25:
            $errdsc = "El cálculo de la retención del IVA no es correcto.";
            break;
        case 26:
            $errdsc = "El período del número del comprobante en la retención del IVA no corresponde a la fecha de la factura.";            
            break;
        case 27:
            $errdsc = "El período del número de comprobante de la retención del IVA y su fecha deben coincidir.";
            break;
        case 28:
            $errdsc = "El número de comprobante de la retención del IVA es inválido.";
            break;            
        case 29:
            $errdsc = "No se seleccionó ningún archivo como comprobante de retención del IVA.";
            break;
        case 30:
            $errdsc = "El archivo de la retención del IVA debe ser formato PDF.";
            break;
        case 200:
            $errdsc = "";
            break;            
        default:
            $errdsc = "";
            $errType = 0;
    } 
    
    //$errdsc = mb_convert_encoding($errdsc, "UTF-8");

    // Se asignan [] para los warning y () para los critical
    if($errType > 0){
        if($errType == 1){ $errType = "[".$errno."] "; }else{ $errType = "(".$errno.") ";}
    }

    return $errType.$errdsc."|";
}

function doc_val(){
    global $db;
    $errMsg = "";
    if (isset($_REQUEST["id"]) )         { $documentid = $db->real_escape_string($_REQUEST["id"])*1;};
    if (isset($_REQUEST["customerid"]) ) { $customerid = $db->real_escape_string($_REQUEST["customerid"])*1;}
    
    if (isset($_REQUEST["docdate"]) )       { $docdate      = $db->real_escape_string($_REQUEST["docdate"]);}
    if (isset($_REQUEST["doctype"]) )       { $doctype      = $db->real_escape_string($_REQUEST["doctype"])*1;}
    if (isset($_REQUEST["docnumber"]) )     { $docnumber    = $db->real_escape_string($_REQUEST["docnumber"]);}
    if (isset($_REQUEST["doccontrol"]) )    { $doccontrol   = $db->real_escape_string($_REQUEST["doccontrol"]);}
    if (isset($_REQUEST["base"]) )          { $base         = $db->real_escape_string($_REQUEST["base"])*1;}
    if (isset($_REQUEST["total"]) )         { $total        = $db->real_escape_string($_REQUEST["total"])*1;}
    if (isset($_REQUEST["pagado"]) )        { $pagado       = $db->real_escape_string($_REQUEST["pagado"])*1;}

    if (isset($_REQUEST["islramount"]) ) { $islramount = $db->real_escape_string($_REQUEST["islramount"])*1;}else{ $islramount=0;}
    if (isset($_REQUEST["ivaamount"]) )  { $ivaamount  = $db->real_escape_string($_REQUEST["ivaamount"])*1;}else{  $ivaamount=0;}


    if( (empty($base) || empty($total) || empty($pagado)) ){
        $errMsg .= valerr(2);
    }

    if(isset($docnumber) && strlen($docnumber) > 20){
        $errMsg .= valerr(3);
    }
    
    if(isset($doccontrol) && (strlen($doccontrol) <> 11) 
                          || (substr($doccontrol,2,1)<>"-" )
                          || !is_numeric(substr($doccontrol,0,2))
                          || !is_numeric(substr($doccontrol,3))
       ){
        $errMsg .= valerr(4);   
    }

    if( !isset($_REQUEST["islrswitch"]) && !isset($_REQUEST["ivaswitch"]) ){
        $errMsg .= valerr(5);
    }

    if( isset($total) && isset($pagado)){
        if( ($total - ($islramount + $ivaamount + $pagado)) > 0.01 ){
//        if( (round($total,2) - ( round($islramount,2) + round($ivaamount,2) )) > round($pagado,2) ){
            $errMsg .= valerr(9);
        }
    }

    // Se valida de que no exista la factura previamente 
    $sql =  "SELECT id FROM documents WHERE (docnumber = ? OR doccontrol = ? )".
                                      " AND id <> ?" ;
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("sss", $docnumber, $doccontrol, $documentid);
            
    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    $numofrecords = mysqli_num_rows($result);  
    if ($numofrecords > 0){
        $errMsg .= valerr(8);
    }    
    
    return $errMsg;
}


function islr_val(){
    global $db;
    $errMsg = "";
    if (isset($_REQUEST["id"]) )         { $documentid = $db->real_escape_string($_REQUEST["id"])*1;};
    if (isset($_REQUEST["customerid"]) ) { $customerid = $db->real_escape_string($_REQUEST["customerid"])*1;}


    if (!isset($_REQUEST["islrdate"]) || empty($_REQUEST["islrdate"]) ){ 
        $errMsg .= valerr(10);
    }else{
        $islrdate  = $db->real_escape_string($_REQUEST["islrdate"]);
        $islrdate = DateTime::createFromFormat('d/m/Y', $islrdate)->format('Ymd');
        $docdate   = $db->real_escape_string($_REQUEST["docdate"]);
        $docdate  = DateTime::createFromFormat('d/m/Y', $docdate)->format('Ymd');
        if( $islrdate < $docdate ){
            $errMsg .= valerr(11);
        }
    }
    
    // if (!isset($_REQUEST["islrnumber"]) || empty($_REQUEST["islrnumber"]) ){
    //     $errMsg .= valerr(12);
    // }else{
        if (isset($_REQUEST["id"]) && isset($_REQUEST["customerid"])){
            $islrnumber = $db->real_escape_string($_REQUEST["islrnumber"]);
            $sql =  "SELECT retislr.id FROM retislr " .
                    "INNER JOIN documents ON documents.id  = retislr.documentid " .
                    "WHERE customerid = ? AND documentid <> ? AND islrnumber = ?";
            //Preparamos el statement
            $stmt =  $db->prepare($sql);
            //Remplazamos los parametros en la consulta almacenada
            $stmt->bind_param("sss", $customerid, $documentid, $islrnumber);
                    
            //Validamos la ejecución
            if (!($stmt->execute())){
                http_response_code(500);
                $salida->rsp = false ;
                $salida->sql = $sql ;
                $salida->msg = mysqli_error($db);
                echo (json_encode($salida));
                return;
            }
            //Obtenemos los resultados y recorremos
            $result = $stmt->get_result();
            $numofrecords = mysqli_num_rows($result);  
            if( $numofrecords > 0){
                $errMsg .= valerr(13);
            }
        }
    // }
    
    if (!isset($_REQUEST["islramount"]) || $_REQUEST["islramount"]*1 <= 0 ){ 
        $errMsg .= valerr(14);
    }else{
        $base         = $db->real_escape_string($_REQUEST["base"])*1;
        $islramount   = $db->real_escape_string($_REQUEST["islramount"])*1;
        
        if($base > 0){
            // Arreglo de Impuestos validos del ISLR
            $islr_valid = array(1, 2, 3, 5);
            
            $sustraendo = array("PJD"=>35, "PJND"=>37, "PNR"=>43, "PNNR"=>43 );
            $base_islr  = array("PJD"=>100, "PJND"=>100, "PNR"=>100, "PNNR"=>100 );
            $porc_islr  = array("PJD"=>35, "PJND"=>37, "PNR"=>43, "PNNR"=>43 );
            
            $tasa_islr  = round(($islramount*100)/$base);

            if (in_array($tasa_islr, $islr_valid) == false) {
                $errMsg .= valerr(15);
            }
        }
    }

    if (!isset($_FILES['fileislr']['name']) || empty($_FILES['fileislr']['name']) ){ 
        $islrfile = "../../../data/customer/islr/".$documentid.".pdf";
        if( !file_exists ($islrfile)){
            $errMsg .= valerr(16);
        }
    }else{
        $extfile = $_FILES['fileislr']['type'];
        if( $extfile <> "application/pdf"){
            $errMsg .= valerr(17);
        }
    }

    return $errMsg;
}

// http://declaraciones.seniat.gob.ve/portal/page/portal/MANEJADOR_CONTENIDO_SENIAT/05MENU_HORIZONTAL/5.1ASISTENCIA_CONTRIBUYENTE/5.1.2ORIENTACION_GENERA/5.1.2.1TRAMITES_ELECTRONI/DIRIVA.pdf
function iva_val(){
    global $db;
    $errMsg = "";
    
    if (isset($_REQUEST["id"]) )         { $documentid = $db->real_escape_string($_REQUEST["id"])*1;};
    if (isset($_REQUEST["customerid"]) ) { $customerid   = $db->real_escape_string($_REQUEST["customerid"])*1;}

    if (!isset($_REQUEST["ivadate"]) || empty($_REQUEST["ivadate"])){ 
        $errMsg .= valerr(20);
    }else{
        $ivadate  = $db->real_escape_string($_REQUEST["ivadate"]);
        $ivadate = DateTime::createFromFormat('d/m/Y', $ivadate)->format('Ymd');
        $docdate   = $db->real_escape_string($_REQUEST["docdate"]);
        $docdate  = DateTime::createFromFormat('d/m/Y', $docdate)->format('Ymd');
        if( $ivadate < $docdate ){
            $errMsg .= valerr(21);
        }
    }
    
    
    if (!isset($_REQUEST["ivanumber"]) || empty( $_REQUEST["ivanumber"])){
        $errMsg .= valerr(22);
    }else{
        $ivanumber   = $db->real_escape_string($_REQUEST["ivanumber"]);
        
        if(strlen($ivanumber) <>14 || strlen($ivanumber) >20 || !is_numeric($ivanumber) ){
            $errMsg .= valerr(28);
        }
        
        if (isset($_REQUEST["id"]) && isset($_REQUEST["customerid"])){
            $sql =  "SELECT retiva.id FROM retiva ".
                    "INNER JOIN documents ON documents.id  = retiva.documentid " .
                    "WHERE customerid = ? AND documentid <> ? AND ivanumber = ? ";
            
            //Preparamos el statement
            $stmt =  $db->prepare($sql);
            //Remplazamos los parametros en la consulta almacenada
            $stmt->bind_param("sss", $customerid, $documentid, $ivanumber);
                    
            //Validamos la ejecución
            if (!($stmt->execute())){
                http_response_code(500);
                $salida->rsp = false ;
                $salida->sql = $sql ;
                $salida->msg = mysqli_error($db);
                echo (json_encode($salida));
                return;
            }
            //Obtenemos los resultados y recorremos
            $result = $stmt->get_result();
            $numofrecords = mysqli_num_rows($result);    
            if( $numofrecords > 0){
//$errMsg .= "(00) $customerid ,$documentid: ". $customerid .",". $documentid.",".$ivanumber." - Error de numero ";
                $errMsg .= valerr(22);
            }
        }
    }
    

    if (!isset($_REQUEST["ivaamount"]) || $_REQUEST["ivaamount"]*1 <= 0 ){ 
        $errMsg .= valerr(24);
$errMsg .= "(00) ". $iva_value .",". $tasa_iva." - ";        
    }else{
        $base        = $db->real_escape_string($_REQUEST["base"])*1;
        $total       = $db->real_escape_string($_REQUEST["total"])*1;
        $ivaamount   = $db->real_escape_string($_REQUEST["ivaamount"])*1;

        if($base > 0){
            // Arreglo de Impuestos validos del IVA
            $iva_valid  = array(12, 22, 32, 16, 26, 36);
            $tasa_retiva = 0.75;
            $iva_value   = ($total - $base);
            $tasa_iva    = round(($iva_value*100)/$base,2);

            if (in_array($tasa_iva, $iva_valid) == false) {
                $errMsg .= valerr(24);
            }
            
            if ( (round(($iva_value*$tasa_retiva),2)-$ivaamount) <> 0) {
                $errMsg .= valerr(25);
            }
        }
    }
    
    // Validacion del periodo del comprobante
    if ( isset($_REQUEST["ivanumber"]) && !empty( $_REQUEST["ivanumber"]) &&
         isset($_REQUEST["ivadate"])   && !empty($_REQUEST["ivadate"])    &&
         isset($_REQUEST["docdate"])   && !empty($_REQUEST["docdate"])){ 
             
             
        $ivadate = $db->real_escape_string($_REQUEST["ivadate"]);
        $docdate = $db->real_escape_string($_REQUEST["docdate"]);
        $anomesiva = DateTime::createFromFormat('d/m/Y', $ivadate)->format('Ym');
        $anomesdoc = DateTime::createFromFormat('d/m/Y', $docdate)->format('Ym');
        $periodo = substr($_REQUEST["ivanumber"], 0, 6);

        if( $anomesdoc > $periodo){
            $errMsg .= valerr(26);
        }
        
        if( $anomesiva <> $periodo){
            $errMsg .= valerr(27);
        }
    }


    if (!isset($_FILES['fileiva']['name']) || empty($_FILES['fileiva']['name']) ){ 
        $ivafile = "../../../data/customer/iva/".$documentid.".pdf";
        if( !file_exists ($ivafile)){
            $errMsg .= valerr(29);    
        }
    }else{
        $extfile = $_FILES['fileiva']['type'];
        if( $extfile <> "application/pdf"){
            $errMsg .= valerr(30);
        }
    }

    return $errMsg;
}


// Subir archivo al Servidor (https://www.w3schools.com/php/php_file_upload.asp)
// https://www.youtube.com/watch?v=miOz8AhLDnc //
function upload_file( $fileToUpload){
    global $db;
    $target_dir = "uploads/";
    //if (!file_exists($target_dir)){   // Se verifica que el directorio destino exista sino se crea
    //    mkdir('upload',0777,true);
    //}
    $target_file = $target_dir . basename($_FILES["fileToUpload"]["name"]);
    $target_file = $target_dir . basename($fileToUpload);
    $fileType    = strtolower(pathinfo($target_file,PATHINFO_EXTENSION));
    $uploadOk = 1;
    
    // Check if file already exists
    if (file_exists($target_file)) {
        $errMsg = "<br>Archivo ya existente.";
        $uploadOk = 0;
    }
    // Check file size
    if ($_FILES[$fileToUpload]["size"] > 100000) {
        $errMsg =  "<br>Archivo es muy largo.";
        $uploadOk = 0;
    }
    // Allow certain file formats
    if($fileType != "pdf" && $fileType != "jpg" && $fileType != "png" && $fileType != "jpeg") {
        $errMsg =  "<br>Sólo permitido formatos PDF, JPG, JPEG, PNG.";
        $uploadOk = 0;
    }
    // Check if $uploadOk is set to 0 by an error
    if ($uploadOk == 0) {
        $errMsg =  "Disculpe, el archivo no fue cargado." . $errMsg ;
        $salida->rsp   = false;
        $salida->errno = -1;
        $salida->msg   = "El archivo ". basename( $_FILES[$fileToUpload]["name"]). "no fué cargado. " .  $errMsg;
    // if everything is ok, try to upload file
    } else {
        $fileFrom  = $_FILES[$fileToUpload]["tmp_name"];
        $fileTo    = $target_file;
        if (move_uploaded_file( $fileFrom, $fileTo)) {
            $salida->rsp = true;
            $salida->msg = "El archivo ". basename( $_FILES[$fileToUpload]["name"]). " fu谷 cargado.";
        } else {
            $salida->rsp   = false;
            $salida->errno = -1;
            $salida->msg   = "Hubo un error al subir el archivo.";
        }
    }

    $salida->files    = $target_file;
    $salida->fileType = $fileType ;
    $salida->origen   = $fileToUpload;
    $salida->destino  = $target_file;    
    return (json_encode($salida));
}

?>
