<?php
    header("Content-Type:application/json");
    include("../connection.php");
    $errMsg = "";
    $salida = new stdClass();
    
    if (!isset($_REQUEST["sessid"])     || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid. "; }
    if (!isset($_REQUEST["id"]))                                        { $errMsg .= "No se recibio el Parametro id. "; }
    if (!isset($_REQUEST["userid"])     || empty($_REQUEST["userid"]) ) { $errMsg .= "No se recibio el Parametro userid. "; }
    if (!isset($_REQUEST["name"])       || empty($_REQUEST["name"]) )   { $errMsg .= "No se recibio el Parametro name. "; }
    if (!isset($_REQUEST["email"])      || empty($_REQUEST["email"]) )  { $errMsg .= "No se recibio el Parametro email. "; }

    $sessid = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    $id = intval($db->real_escape_string($_REQUEST["id"]));

    if (isset($_REQUEST["status"]) ){ 
        $status = 1;
    }else{
        $status = 0;
    }
    
    if (isset($_REQUEST["accs_customers"]) ){ $accs_customers = 1; }else{ $accs_customers = 0; }
    if (isset($_REQUEST["accs_invoices"])  ){ $accs_invoices  = 1; }else{ $accs_invoices  = 0; }
    if (isset($_REQUEST["accs_approve"])   ){ $accs_approve   = 1; }else{ $accs_approve   = 0; }
    if (isset($_REQUEST["accs_reports"])   ){ $accs_reports   = 1; }else{ $accs_reports   = 0; }
    if (isset($_REQUEST["accs_refuse"])    ){ $accs_refuse    = 1; }else{ $accs_refuse    = 0; }
    if (isset($_REQUEST["accs_users"])     ){ $accs_users     = 1; }else{ $accs_users     = 0; }



    if(!empty($errMsg)){
        http_response_code(401);
        $salida->rsp = false ;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }
        
    $userid     = ($db->real_escape_string($_REQUEST["userid"]));
    $name       = preg_replace("/[^a-zA-Z0-9 _-áéíóúÁÉÍÓÚÑñ]/", "", $db->real_escape_string($_REQUEST["name"]));
    $email      = preg_replace("/[^a-zA-Z0-9@.-_]/", "", $db->real_escape_string($_REQUEST["email"]));

    mysqli_query($db, "SET lc_time_names = 'es_ES'");
    
    /* Se valida el usuario y la session */
    $sql =  "SELECT id FROM users ".
            "WHERE  sessionid = ? AND IF(CURDATE()<sessionvalidthru, 1, 0)" ;
    
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $sessid);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
        case 0:
            http_response_code(401);
            $salida->rsp = false ;
            $salida->msg = "Sesión invalida o terminada";
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
            $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            echo (json_encode($salida));
            return;
            break;
        }
    }


    /************** Validaciones **********************/    
    $errlvl  = 0;
    $errMsg  = "";
    $salir = false;
    
    $errMsg .=  val_registro();      // Validacion Documento

    // Se verifica el nivel de error segun la descripción en 0 sin error, 1 Warning, 2 Critical    
    if(empty($errMsg)){
        $errlvl = 0;
    }else{
        $errMsg = parseErrMsg( $errMsg);
        $errlvl = substr($errMsg,0,1)*1;
        $errMsg = substr($errMsg,1);
        http_response_code(400);
        $salida->rsp = false;
        $salida->errlvl = $errlvl;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }


    /* Se valida si el registro es nuevo o no para hacer insert o update */
    $sql =  "SELECT id FROM users WHERE id = " .$id;
    if (!($qry = mysqli_query($db, $sql))){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        $salida->sql = $sql ;
        echo (json_encode($salida));
        return;
    }
    $rs = mysqli_fetch_array($qry);
    $numofrecords = mysqli_num_rows($qry) ;  

    if ($numofrecords > 0){ $newrecord = false; }else{ $newrecord = true; }

    if($newrecord){
         $sql  = "INSERT INTO users (" ;
         /*
         if (isset($userid))         {$sql .= "user";}
         if (isset($name))           {$sql .= ", name";}
         if (isset($email))          {$sql .= ", email";}
         if (isset($status))         {$sql .= ", status";}
         if (isset($accs_customers)) {$sql .= ", accs_customers";}
         if (isset($accs_invoices))  {$sql .= ", accs_invoices";}
         if (isset($accs_approve))   {$sql .= ", accs_approve";}
         if (isset($accs_refuse))    {$sql .= ", accs_refuse";}
         if (isset($accs_reports))   {$sql .= ", accs_reports";}
         if (isset($accs_users))     {$sql .= ", accs_users";}
         $sql .= " ) VALUES ( ";
         if (isset($userid))         {$sql .= "  '".$userid."'";}
         if (isset($name))           {$sql .= ", '".$name.  "'";}
         if (isset($email))          {$sql .= ", '".$email. "'";}
         if (isset($status))         {$sql .= ",  ".$status;}
         if (isset($accs_customers)) {$sql .= ",  ".$accs_customers;}
         if (isset($accs_invoices))  {$sql .= ",  ".$accs_invoices;}
         if (isset($accs_approve))   {$sql .= ",  ".$accs_approve;}
         if (isset($accs_refuse))    {$sql .= ",  ".$accs_refuse;}
         if (isset($accs_reports))   {$sql .= ",  ".$accs_reports;}
         if (isset($accs_users))     {$sql .= ",  ".$accs_users;}
         */
         $sql .= " user, name, email, status, accs_customers, accs_invoices, accs_approve, accs_refuse, accs_reports, accs_users ";
         $sql .= " ) VALUES ( ";
         $sql .= " ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ";
         $sql .= " )";
        //Preparamos el statement
        $stmt =  $db->prepare($sql);
        //Remplazamos los parametros en la consulta almacenada
        $stmt->bind_param("ssssssssss", $userid, $name, $email, $status, $accs_customers, $accs_invoices, $accs_approve, $accs_refuse, $accs_reports, $accs_users);
    }else{
        $sql =  "UPDATE users SET " ;
        /*
                if (isset($userid))         {$sql .= " user   = '"  .$userid. "', ";}
                if (isset($name))           {$sql .= " name   = '"  .$name.   "', " ;}
                if (isset($email))          {$sql .= " email  = '"  .$email.  "', " ;}
                if (isset($status))         {$sql .= " status =  "  .$status. ", " ;}
                if (isset($accs_customers)) {$sql .= " accs_customers =  "  .$accs_customers. ", " ;}
                if (isset($accs_invoices))  {$sql .= " accs_invoices  =  "  .$accs_invoices. ", " ;}
                if (isset($accs_approve))   {$sql .= " accs_approve   =  "  .$accs_approve. ", " ;}
                if (isset($accs_refuse))    {$sql .= " accs_refuse    =  "  .$accs_refuse. ", " ;}
                if (isset($accs_reports))   {$sql .= " accs_reports   =  "  .$accs_reports. ", " ;}
                if (isset($accs_users))     {$sql .= " accs_users     =  "  .$accs_users. " " ;}
        */
        $sql .= " user   = ?, ";
        $sql .= " name   = ?, ";
        $sql .= " email   = ?, ";
        $sql .= " status   = ?, ";
        $sql .= " accs_customers   = ?, ";
        $sql .= " accs_invoices   = ?, ";
        $sql .= " accs_approve   = ?, ";
        $sql .= " accs_refuse   = ?, ";
        $sql .= " accs_reports   = ?, ";
        $sql .= " accs_users   = ? ";
        $sql .= "WHERE id = ?";
        //Preparamos el statement
        $stmt =  $db->prepare($sql);
        //Remplazamos los parametros en la consulta almacenada
        $stmt->bind_param("sssssssssss", $userid, $name, $email, $status, $accs_customers, $accs_invoices, $accs_approve, $accs_refuse, $accs_reports, $accs_users, $id);
    }

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        $salida->sql = $sql ;
        echo (json_encode($salida));
        return;
    }
    if($newrecord){ $id = mysqli_insert_id($db); } // Se recupera el ultimo ID de la mas reciente ejecución de comando SQL    

    if(empty($errMsg)){
        http_response_code(200);
        $salida->rsp        = true;
        $salida->errlvl     = 0;
        $salida->errdsc     = "";
        echo (json_encode($salida));
        return;
    }else{
        http_response_code(200);
        $salida->rsp        = false;
        $salida->errlvl     = $errlvl;
        $salida->errdsc     = $errMsg;
        $salida->sql        = $sql;
        echo (json_encode($salida));
        return;
    }

function parseErrMsg( $errMsg){
    global $db;
    
    $limiterW = ")";
    $limiterC = "]";
    $pos = strpos($errMsg, $limiterW);
    if( !$pos || empty($pos) ){ $errlvl = 1; }else{ $errlvl = 2; }
    
    // Parse de los mensajes de error para eliminar el numero de error al jSon
    $newErrMsg = "";
    $errArray = explode("|",$errMsg);
    sort($errArray);
    foreach ($errArray as $value) {
        // Se consigue la posicion de ] ó ) en el string para eliminar el numero
        $pos = strpos($value, $limiterW);
        if( !$pos || empty($pos) ){ 
            $pos = strpos($value, $limiterC); 
        }
        if($pos > 0 && !empty($value)){
            $value = substr( $value, $pos+1);
            $newErrMsg .= $value . "|";
        }
    }
    $errMsg = $errlvl.$newErrMsg;
    return $errMsg;
}

function valerr($errno){
    global $db;
    /* errType: Indica si es (1) Warning o (2) Critical error*/
    $errType = 1;
    
    switch ($errno) {
        case 1:
            $errdsc = "No se especificó el USERID";
            $errType = 2;
            break;
        case 2:
            $errdsc = "No se especificó el NOMBRE o RAZÓN SOCIAL del cliente";
            break;
            $errType = 2;
        case 3:
            $errdsc = "No se especificó el CORREO ELECTRÓNICO del cliente";
            break;            
        case 4:
            $errdsc = "Existe un usuario registrado previamente con el mismo valor de USERID";
            $errType = 2;
            break;    
        case 5:
            $errdsc = "Dirección de correo no es válida.";
            $errType = 2;
            break;
        default:
            $errdsc = "";
            $errType = 0;
    } 
    
    // Se asignan [] para los warning y () para los critical
    if($errType > 0){
        if($errType == 1){ $errType = "[".$errno."] "; }else{ $errType = "(".$errno.") ";}
    }

    return $errType.$errdsc."|";
}

function val_registro(){
    global $db;
    $errMsg = "";

    $id     = $_REQUEST["id"]*1;
    $userid = $_REQUEST["userid"];
    $name   = $_REQUEST["name"];
    $email  = $_REQUEST["email"];
    if (isset($_REQUEST["status"])) { $status = 1;}else{$status = 0;}

    if(empty($userid)){ $errMsg .= valerr(1);}
    if(empty($name))  { $errMsg .= valerr(2);}
    if(empty($email)) { $errMsg .= valerr(3);}

    // Se valida de que no exista previamente ----
    
    if( chkprevreg( "user = '".$userid."'" ) ) { $errMsg .= valerr(4);}

    // Se valida el correo electronico valido
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errMsg .= valerr(5);
    }
    return $errMsg;
}

function chkprevreg( $where){
    global $db;
    $id = $_REQUEST["id"]*1;
    $salida = false;
    
    if( $id > 0 ){
        $sql = "SELECT id FROM users WHERE id <> " .$id . " AND " . $where  ;
    }else{
        $sql = "SELECT id FROM users WHERE " . $where  ;
    }
    if (!($qry = mysqli_query($db, $sql))){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->sql = $sql;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    $numofrecords = mysqli_num_rows($qry) ;  
    if ($numofrecords > 0){ $salida = true;}
    
    return $salida;
}


?>
