<?php
    
    include("../connection.php");
    $errMsg = "";
    if (!isset($_REQUEST["sessid"])   || empty($_REQUEST["sessid"]) )  { $errMsg .= "No se recibio el Parametro sessid. "; }
    if (!isset($_REQUEST["records"])  || empty($_REQUEST["records"]))  { $errMsg .= "No se recibio el Parametro records. "; }
    if (!isset($_REQUEST["filename"]) || empty($_REQUEST["filename"])) { $filename = "reporte.csv"; }

    $fReport  = date("Y-m-d h:i:s");
    
    if (isset($_REQUEST["fReport"]) && !empty($_REQUEST["fReport"]) && $_REQUEST["fReport"] !== NULL){
        $fReport = $_REQUEST["fReport"];
        $fReport = substr($fReport,6,4)."-".substr($fReport,3,2)."-".substr($fReport,0,2).substr($fReport,10);
    }

    $sessid  = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    $records = preg_replace("/[^0-9\|]/", "", $db->real_escape_string($_REQUEST["records"]));
    
//    header('Content-Type: application/csv');
//    header('Content-Disposition: attachment; filename="'.$filename.'";');

    if(!empty($errMsg)){
        http_response_code(401);
        $salida->rsp = false ;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }
        
    mysqli_query($db, "SET lc_time_names = 'es_ES'");
    
    /* Se valida el usuario y la session */
    $sql =  "SELECT id, accs_reports FROM users ".
            "WHERE  sessionid = ? AND IF(CURDATE()<sessionvalidthru, 1, 0)" ;
    
    
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $sessid);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
        switch (mysqli_errno($db)){
            case 0:
                http_response_code(401);
                $salida->rsp = false ;
                $salida->msg = "Sesión invalida o terminada";
                echo (json_encode($salida));
                return;
                break;
            default:
                http_response_code(500);
                $salida->rsp = false ;
                $salida->msg = mysqli_error($db);
                echo (json_encode($salida));
                return;
                break;
            }
    }

    // Se verifica si tiene permiso
    if ($rs["accs_reports"]*1 < 1){
        http_response_code(401);
        $salida->rsp = false ;
        $salida->msg = "No tiene los privilegios para reportar";
        $salida->name = $rs["name"];
        $salida->accs = $rs["accs_reports"]*1;
        $salida->sessid = $sessid;
        echo (json_encode($salida));
        return;
    }else{
        header('Content-Type: application/csv');
        header('Content-Disposition: attachment; filename="'.$filename.'";');
    }



    $lista = str_replace("|", ",", $records);
    
    $records = explode("|", $records);
    $no_recs = count($records);
    $success = array();


    //$sql = "UPDATE retislr SET repdate = NOW() WHERE  documentid IN (" . $lista . ")";
    $sql = "UPDATE retislr SET repdate = ? WHERE  documentid IN (" . $lista . ")";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $fReport);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(200);
        //echo(mysql_error());
        echo("Ocurrió un ERROR 1");
        return;
    }
    $sql =  "SELECT I.repdate, 'Impuesto sobre la renta' tipo, 'Medio Pago SAP' mediopago, '              ' mediopago1, " .
            "       C.custid, C.nickname, D.docnumber, FLOOR(I.amount) unidades, Floor((I.amount-FLOOR(I.amount))*100) decimales, " .
            "       C.name razonSocial, D.doccontrol, C.rif " .
            "FROM   documents D ".
            "       INNER JOIN customers C ON C.id = D.customerid ".
            "       INNER JOIN retislr I  ON I.documentid = D.id ".
            "WHERE  D.id IN (" . $lista . ")";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    //$stmt->bind_param("s", $lista);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(200);
        //echo(mysql_error());
        echo("Ocurrió un ERROR 3");
        return;
    }

    $f = fopen('php://output', 'w');
    fprintf($f, chr(0xEF).chr(0xBB).chr(0xBF)); /* https://stackoverflow.com/questions/21988581/write-utf-8-characters-to-file-with-fputcsv-in-php */
    fputcsv($f, array("Site", "Fecha de acreditación", "Cust ID", "Nickname", "RIF", "Cliente", "Tipo de retención", "Medio de Pago Sap", "Número de factura", "Numero de Control", "Unidades", "Decimales"), ";");
    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    while ($rs = mysqli_fetch_array($result)){
        fputcsv($f, array("MLV", $rs["repdate"], $rs["custid"], $rs["nickname"], $rs["rif"], $rs["razonSocial"], $rs["tipo"], $rs["mediopago1"], $rs["docnumber"], $rs["doccontrol"], $rs["unidades"], $rs["decimales"]), ";");
    }
    
    //$sql = "UPDATE retiva SET repdate = NOW() WHERE  documentid IN (" . $lista . ")";
    $sql = "UPDATE retiva SET repdate = ? WHERE  documentid IN (" . $lista . ")";
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("s", $fReport);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(200);
        //echo(mysql_error());
        echo("Ocurrió un ERROR 2");
        return;
    }
/*    
    $sql =  "SELECT I.repdate, 'Impuesto sobre la renta' tipo, 'Medio Pago SAP' mediopago, '              ' mediopago1, " .
            "       C.custid, C.nickname, d.docnumber, FLOOR(I.amount) unidades, Floor((I.amount-FLOOR(I.amount))*100) decimales " .
            "FROM   documents D ".
            "       INNER JOIN customers C ON C.id = D.customerid ".
            "       INNER JOIN retiva I ON I.documentid = D.id ".
            "WHERE  D.id IN (" . $lista . ")";
*/            
    $sql =  "SELECT I.repdate, 'Impuesto sobre el valor agregado' tipo, 'Medio Pago SAP' mediopago, '              ' mediopago1, " .
            "       C.custid, C.nickname, D.docnumber, FLOOR(I.amount) unidades, Floor((I.amount-FLOOR(I.amount))*100) decimales, " .
            "       C.name razonSocial, D.doccontrol, C.rif " .
            "FROM   documents D ".
            "       INNER JOIN customers C ON C.id = D.customerid ".
            "       INNER JOIN retiva I ON I.documentid = D.id ".
            "WHERE  D.id IN (" . $lista . ")";            
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    //$stmt->bind_param("s", $lista);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(200);
        //echo(mysql_error());
        echo("Ocurrió un ERROR 4");
        return;
    }
    $result = $stmt->get_result();
    while ($rs = mysqli_fetch_array($result)){
        fputcsv($f, array("VML", $rs["repdate"], $rs["custid"], $rs["nickname"], $rs["rif"], $rs["razonSocial"], $rs["tipo"], $rs["mediopago1"], $rs["docnumber"], $rs["doccontrol"], $rs["unidades"], $rs["decimales"]), ";");
    }
?>
