<?php
    /* reject.php */
    header("Content-Type:application/json");
    include("../connection.php");
    include($_SERVER['DOCUMENT_ROOT']."/mlretenciones/Aws/amazon-ses.php");
    $errMsg = "";
    if (!isset($_REQUEST["sessid"])     || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid. "; }
    if (!isset($_REQUEST["records"])    || empty($_REQUEST["records"])) { $errMsg .= "No se recibio el Parametro records. "; }
    if (!isset($_REQUEST["msg"])        || empty($_REQUEST["msg"]))     { $errMsg .= "No se recibio el Parametro msg. "; }
    
    $salida = new stdClass();

    $sessid  = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));
    $records = preg_replace("/[^0-9\|]/", "", $db->real_escape_string($_REQUEST["records"]));
    $msg     = preg_replace("/[^a-zA-Z0-9 @#._-áéíóúÁÉÍÓÚÑñ]/", "", $db->real_escape_string($_REQUEST["msg"]));

    if(!empty($errMsg)){
        http_response_code(401);
        $salida->rsp = false ;
        $salida->msg = $errMsg;
        echo (json_encode($salida));
        return;
    }
        
    mysqli_query($db, "SET lc_time_names = 'es_ES'");
    
    /* Se valida el usuario y la session */
    $sql =  "SELECT id, name, email, accs_refuse FROM users ".
            "WHERE  sessionid = '" .$sessid. "' AND IF(CURDATE()<sessionvalidthru, 1, 0)" ;
    
    if (!($qry = mysqli_query($db, $sql))){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        echo (json_encode($salida));
        return;
    }
    
    if (!($rs = mysqli_fetch_array($qry))){
        switch (mysqli_errno($db)){
            case 0:
                http_response_code(401);
                $salida->rsp = false ;
                $salida->err = 0;
                $salida->msg = "Sesión invalida o terminada";
                echo (json_encode($salida));
                return;
                break;
            default:
                http_response_code(500);
                $salida->rsp = false ;
                $salida->err = 1;
                $salida->msg = mysqli_error($db);
                echo (json_encode($salida));
                return;
                break;
        }
    }

    // Se verifica si tiene permiso
    if ($rs["accs_refuse"]*1 < 1){
        http_response_code(401);
        $salida->rsp = false ;
        $salida->msg = "No tiene los privilegios para rechazar facturas";
        $salida->name = $rs["name"];
        $salida->accs = $rs["accs_refuse"]*1;
        $salida->sessid = $sessid;
        echo (json_encode($salida));
        return;
    }

    $lista = "'" . str_replace("|", "','", $records) . "'";
    
    $records = explode("|", $records);
    $no_recs = count($records);
    $success = array();
    
    $sql = "UPDATE documents SET errlvl = 3, errdsc='" . $msg . "|' WHERE id IN (" . $lista . ")";
    if ((!$qry = mysqli_query($db, $sql))){
        http_response_code(200);
        $salida->rsp        = false;
        $salida->err = 2;
        $salida->msg        = "docments: Ocurrió un error al rechazar: " . mysqli_error($db);
        echo (json_encode($salida));    
        return;
    }
    // quitar el símbolo de aprobado en los estatus y fecha de reporte
    $sql = "UPDATE retiva SET status = 3, repdate = null where documentid IN (" . $lista . ")";;
    if ((!$qry = mysqli_query($db, $sql))){
        http_response_code(200);
        $salida->rsp        = false;
        $salida->err = 3;
        $salida->msg        = "retiva: Ocurrió un error al rechazar: " . mysqli_error($db);
        echo (json_encode($salida));    
        return;
    }
    $sql = "UPDATE retislr SET status = 3, repdate = null where documentid IN (" . $lista . ")";;
    if ((!$qry = mysqli_query($db, $sql))){
        http_response_code(200);
        $salida->rsp        = false;
        $salida->err = 4;
        $salida->msg        = "retislr: Ocurrió un error al rechazar: " . mysqli_error($db);
        echo (json_encode($salida));    
        return;
    }

    reject_notify( $lista);

    http_response_code(200);
    $salida->rsp = true;
    $salida->err = 5;
    if( $no_recs > 1){
        $salida->msg = "Se rechazaron " . $no_recs . " facturas";
    }else{
        $salida->msg = "Se rechazó la factura";
    }
    //$salida->sql = $sql;
    echo (json_encode($salida));    
//    mysql_free_result($qry);
    return;

function reject_notify( $lista ){
    global $db;
    /* Se recupera los datos de la factura */
    $sql =  "SELECT  customers.name, customers.email, documents.docnumber, documents.errdsc " .
            "FROM documents " .
            "INNER JOIN customers ON documents.customerid = customers.id " .
            "WHERE documents.id IN (" . $lista . ")";

    if (!($qry = mysqli_query($db, $sql))){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        //$salida->msg = $sql;
        echo (json_encode($salida));
        return;
    }

    while ($rs = mysqli_fetch_array($qry)){
        $customername   = $rs["name"];
        $email          = $rs["email"];
        $docnumber      = $rs["docnumber"];
        $notaderechazo  = $rs["errdsc"];

        $to      =  [$email];
        $subject =  "MercadoLibre - Rechazo de retenciones";
        $headers  = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= 'From: <webmaster@example.com>' . "\r\n";
    
        $msg   = "«html»";
        $msg  .= "      «head» ";
        $msg  .= "          «title»MercadoLibre - Rechazo de retenciones«/title»";
        $msg  .= "      «/head»";
        $msg  .= "      «body»";
        $msg  .= "          «p»Hola, ".$customername."«/p»";
        $msg  .= "          «p»";
        $msg  .= "          Luego de la revisión de las retenciones relacionadas a la factura número ".$docnumber.", no hemos podido procesarla ya que se encontró el siguiente fallo u observación: «br»";
        $msg  .= "          «b»".$notaderechazo."«/b»";
        $msg  .= "          «/p»";
        $msg  .= "          «p»Por favor, revise y corriga la misma.«/p»";
        $msg  .= "          «p»";
        $msg  .= "          Saludos,";
        $msg  .= "          «/p»";
        $msg  .= "          «p»";
        $msg  .= "          Mercado Libre";
        $msg  .= "          «/p»";
        $msg  .= "          «h6»Nota: Este es un correo no supervisado, favor no responder. «/h6»";
        $msg  .= "      «/body»";
        $msg  .= "«/html» ";
        $msg = str_replace("«","<",$msg);
        $msg = str_replace("»",">",$msg);
        enviarEmail($to,$subject,$msg);
        //mail($to,$subject,$msg,$headers);
    }
    mysqli_free_result($qry);
}
?>