<?php
    header("Content-Type:application/json");
    include("../connection.php");
    
    $errMsg = "";
    if (!isset($_REQUEST["sessid"]) || empty($_REQUEST["sessid"]) ) { $errMsg .= "No se recibio el Parametro sessid. "; } 
    if (!isset($_REQUEST["userid"])  || $_REQUEST["userid"] == '')  { $errMsg .= "No se recibio el Parametro userid. "; } 
    
    $salida = new stdClass();
    
    if (!empty($errMsg) ){
        http_response_code(400);
        $salida->rsp = false ;
        $salida->msg = $errMsg;
        $salida->sql = $sql ;
        $salida->errno = 1;
        echo (json_encode($salida));
        return;
    }

    $userid = intval($db->real_escape_string($_REQUEST["userid"]));
    $sessid = preg_replace("/[^a-zA-Z0-9]/", "", $db->real_escape_string($_REQUEST["sessid"]));

    mysqli_query($db, "SET lc_time_names = 'es_ES'");

    $sql =  "SELECT id, name, email as custmail " .
            "FROM   users " .
            "WHERE  id = ? " .
            "AND    sessionid = ? " ;

            
    //Preparamos el statement
    $stmt =  $db->prepare($sql);
    //Remplazamos los parametros en la consulta almacenada
    $stmt->bind_param("ss", $userid, $sessid);

    //Validamos la ejecución
    if (!($stmt->execute())){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        $salida->sql = $sql ;
        $salida->errno = 1;
        echo (json_encode($salida));
        return;
    }

    //Obtenemos los resultados y recorremos
    $result = $stmt->get_result();
    if (!($rs = mysqli_fetch_array($result))){
    	switch (mysqli_errno($db)){
    	case 0:
    	    http_response_code(401);
            $salida->rsp = true ;
            $salida->msg = "Sesión invalida o terminada";
            $salida->sql = $sql ;
            $salida->errno = 1;
            echo (json_encode($salida));
            return;
            break;
        default:
            http_response_code(500);
    	    $salida->rsp = false ;
            $salida->msg = mysqli_error($db);
            $salida->sql = $sql ;
            $salida->errno = 2;
            echo (json_encode($salida));
            return;
            break;
    	}
    }
    
    if ($rs["id"]<1){
        http_response_code(500);
        $salida->rsp = false ;
        $salida->msg = mysqli_error($db);
        $salida->sql = $sql ;
        $salida->errno = 3;
        echo (json_encode($salida));
        return;
    }
            
    $username  = $rs["name"];
    $userid    = $rs["id"];
    $usermail  = $rs["custmail"];

    http_response_code(200);
        $salida->rsp = true;
        $salida->username   = $username;
        $salida->userid     = $userid;
        $salida->usermail   = $usermail;
    echo (json_encode($salida));


?>

